function salesNotifTemplate(data){
  return '<div class="wsb-sales-notif__thumbnail rt-img">'+
            '<img src="'+data.product_thumbnail+'" alt="'+data.product_title+'">'+
          '</div>'+
          '<div class="wsb-sales-notif__body">'+
            '<span class="wsb-sales-notif__overtext"><span class="rt-icon"><svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="currentColor" class="bi bi-lightning-charge-fill" viewBox="0 0 16 16"><path d="M11.251.068a.5.5 0 0 1 .227.58L9.677 6.5H13a.5.5 0 0 1 .364.843l-8 8.5a.5.5 0 0 1-.842-.49L6.323 9.5H3a.5.5 0 0 1-.364-.843l8-8.5a.5.5 0 0 1 .615-.09z"/></svg></span>'+data.order_message+'</span>'+
            '<h6 class="wsb-sales-notif__title"><a href="'+data.product_permalink+'">'+data.product_title+'</a></h6>'+
            '<span class="wsb-sales-notif__date">'+data.order_date+'</span>'+
          '</div>';
}

const saleNotif = document.querySelector(".js-sales-notif");

if(saleNotif){

const saleContent = saleNotif.querySelector(".sales_notif_content");
const duration = saleNotif.getAttribute("data-duration");
const show = saleNotif.getAttribute("data-show");
const close = saleNotif.querySelector(".js-sales-notif-close");
const animationIn = saleNotif.getAttribute("data-animatein");
const animationOut = saleNotif.getAttribute("data-animateout");

if (close) {
   close.addEventListener("click", (event) => {
     saleNotif.parentNode.removeChild(saleNotif);
     Cookies.set("wsb_sale_notif", "close");
   });
 }


if (Cookies.get("wsb_sale_notif") != "close") {
  jQuery.ajax({
    url: shop_booster_sales_notif.apiurl,
    type: "GET",
    dataType: "json",
    success: (response) => {
      // loop notif
      var counter = 0;

      var looper = setInterval(function () {
        if (counter >= response.length) {
          counter = 0;
        } else {
          // animation sale popup
          if (counter >= 0) {
            saleContent.innerHTML = salesNotifTemplate(response[counter]);
            animateCSS(saleNotif, animationIn, 300);

            // set time pop up showing
            setTimeout(() => {
              animateCSS(saleNotif, animationOut, 300);
            }, show);
          }
          counter++;
        }
      }, duration);
    },
  });
}
}