/**
 * Class countdown
 * v1.0.0
 * @see https://www.sitepoint.com/build-javascript-countdown-timer-no-dependencies/
 */
class countdown {
  constructor() {
    this.init();
  }
  getTimeRemaining(endtime) {
    const total = Date.parse(endtime) - Date.parse(new Date());
    const seconds = Math.floor((total / 1000) % 60);
    const minutes = Math.floor((total / 1000 / 60) % 60);
    const hours = Math.floor((total / (1000 * 60 * 60)) % 24);
    const days = Math.floor(total / (1000 * 60 * 60 * 24));

    return {
      total,
      days,
      hours,
      minutes,
      seconds,
    };
  }

  initializeClock(id, endtime) {
    const fn = this;
    const clock = document.getElementById(id);
    const daysSpan = clock.querySelector(".countdown_days");
    const hoursSpan = clock.querySelector(".countdown_hours");
    const minutesSpan = clock.querySelector(".countdown_minutes");
    const secondsSpan = clock.querySelector(".countdown_seconds");

    let timeinterval = "";

    function updateClock() {
      const timespan = fn.getTimeRemaining(endtime);

      daysSpan.innerHTML = timespan.days;
      hoursSpan.innerHTML = ("0" + timespan.hours).slice(-2);
      minutesSpan.innerHTML = ("0" + timespan.minutes).slice(-2);
      secondsSpan.innerHTML = ("0" + timespan.seconds).slice(-2);

      if (timespan.total <= 0) {
        clearInterval(timeinterval);
      }

      // remove days
      if (timespan.days < 1) {
        daysSpan.parentNode.style.display = "none";
      }
    }

    updateClock();
    timeinterval = setInterval(updateClock, 1000);
  }

  init() {
    const countdowns = document.querySelectorAll(".js-countdown-timer");

    countdowns.forEach((countdown) => {
      const getId = countdown.getAttribute("id");
      const getDate = document.getElementById(getId).getAttribute("data-date");
      const deadline = new Date(getDate);
      const currentTime = Date.parse(new Date());
      // const timeInMinutes = 10;
      // const deadline = new Date(currentTime + timeInMinutes * 60 * 1000);
      if (currentTime < deadline) {
        this.initializeClock(getId, deadline);
        document.getElementById(getId).classList.add("is-active");
      }else{
        document.getElementById(getId).style = 'none';
      }

      
    });
  }
}

new countdown();